/*------------------------------------------------------------------------------*
 * File Name: Data.h															*
 * Creation: CPY 7/14/2001														*
 * Purpose: Origin C header file for Origin basic Data types					*
 * Copyright (c) OriginLab Corp.	2002 - 2007									*
 * All Rights Reserved															*
 * Modifications:																*
 *  LAS, 1/31/03 commented out NLSFCntrl related items; 						*
 *               using NLSF = LabTalk.NLSF can be used instead					*
 *																				*
 * Danice 9/9/04 v8.0130 REPLACE_DATASET_WITH_VECTORBASE						*
 * Danice 9/11/04 v8.0132 MODIFY_REPLACE_DATASET_WITH_VECTORBASE				*
 * HF 2/24/05 Replace examples to make them complete & compilable function		*
 * Leo 30/03/05 QA70-7449 REWRITE_FITPOLY										*
 * Cloud 03/24/07 QA80-9093 v8.0589 INITIAL_PARAMETERS                          *
 * Cloud 04/03/07 ADD_PEAK_HEIGHT_CALCULATION                                   *
 * Justin 2007-04-04 MODIFY FUCNTION CATEGORY									*
 * Cloud 07/17/07 ADD_FFT_FOR_COMPATIBILITY										*
 * Cloud 01/14/08 REPRESENT_SCALE_BY_EXPONENT_FOR_HUGE_NUMBER					*
 * Cloud 02/21/08 PROVIDE_SEGMENT_CENTER										*
 * Iris 11/10/2009 QA80-13388 ZERO_CROSSING_DIRECTION							*
 *	Folger 11/30/09 CENTRALIZE_CODE_ABOUT_FIND_ROOTS							*
 *	Folger 03/31/10 QA81-15258 XF_GETPTS_NEEDED									*
 *------------------------------------------------------------------------------*/

#ifndef _DATA_H
#define _DATA_H

#include <common.h>

#ifndef _STRING_H
#include <string.h>		// Most likely will need strings
#endif // _STRING_H

#include <OC_types.h>	// Structures used in Origin internal functions

#include <stats_types.h> // statistical struct definitions ///Leo moved from ocmath.h, used in data.h, CPY 3/31/05, moved from origin.h to here

#ifndef _WKSHEET_H
#include <Wksheet.h>
#endif // _WKSHEET_H

#include <vector.h>
#include <MatrixData.h>
#include <curve.h>
/////////////////////////////////////////////////////////
// The following functions are implemented in internal.c.
/////////////////////////////////////////////////////////

//Comments last updated by HF on 3/2/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:min_(global_function)
*/
//double	min(Dataset &ds); // Get the minimum value of a data set.	///Danice REPLACE_DATASET_WITH_VECTORBASE
double	min(vectorbase &vec); // Get the minimum value of vectorbase.

//Comments last updated by HF on 3/2/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:max_(global_function)
*/
//double	max(Dataset &ds); // Get the maximum value of a data set.	///Danice REPLACE_DATASET_WITH_VECTORBASE
double	max(vectorbase &vec); // Get the maximum value of vectorbase.

/**@ >Mathematics>Curve>Basic*/

//Comments last updated by HF on 3/9/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:xatymin_(global_function)
*/
double	xatymin(Curve &crv); // Get the value of X at the minimum Y value of a curve.

//Comments last updated by HF on 3/9/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:xatymax_(global_function)
*/
double	xatymax(Curve &crv); // Get the value of X at the maximum Y value of a curve.

//Comments last updated by HF on 3/9/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:yatxmin_(global_function)
*/
double	yatxmin(Curve &crv); // Get the value of Y at the minimum X value of a curve.

//Comments last updated by HF on 3/9/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:yatxmax_(global_function)
*/
double	yatxmax(Curve &crv); // Get the value of Y at the maximum X value of a curve.

// Category last updated by Joseph on 08/08/2007
/**@ >Mathematics>Vector Analysis>Statistics */
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:y25_(global_function)
*/
//double	y25(Dataset &ds); // Get the 25th percentile of a data set.		///Danice REPLACE_DATASET_WITH_VECTORBASE	///MODIFY_REPLACE_DATASET_WITH_VECTORBASE  ///Iris 03/03/05 REPLACE_DATASET_WITH_VECTORBASE
double	y25(vector &vec); // Get the 25th percentile of vector.

// Category last updated by Joseph on 08/08/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:y50_(global_function)
*/
//double	y50(Dataset &ds); // Get the 50th percentile of a data set.	///Danice REPLACE_DATASET_WITH_VECTORBASE	///MODIFY_REPLACE_DATASET_WITH_VECTORBASE   ///Iris 03/03/05 REPLACE_DATASET_WITH_VECTORBASE
double	y50(vector &vec); // Get the 50th percentile of vector.

// Category last updated by Joseph on 08/08/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:y75_(global_function)
*/
//double	y75(Dataset &ds); // Get the 75th percentile of a data set.	///Danice REPLACE_DATASET_WITH_VECTORBASE	///MODIFY_REPLACE_DATASET_WITH_VECTORBASE  ///Iris 03/03/05 REPLACE_DATASET_WITH_VECTORBASE
double	y75(vector &vec); // Get the 75th percentile of vector.

//Comments last updated by HF on 3/14/2005
//Category last updated by Justin on 2007-04-04
/**@ >Mathematics>Curve>Interpolation */
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:xaty50_(global_function)
*/
double	xaty50(Curve &crv); // Get the interpolated value of X at the average of minimum and maximum of Y values of a curve.

//Comments last updated by HF on 3/10/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:xatasymt_(global_function)
*/
double	xatasymt(Curve &crv); // Get the value of X at a vertical asymptote.

//Comments last updated by HF on 3/10/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:yatasymt_(global_function)
*/
double	yatasymt(Curve &crv); // Get the value of Y at a horizontal asymptote.

//Comments last updated by HF on 3/14/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fwhm_(global_function)
*/
double	fwhm(Curve &crv, double dYoffset = 0); // Get the peak width of a curve at half the maximum Y value.


//Comments last updated by HF on 3/3/2005
//Category last updated by Justin on 2007-04-04
/**@ >Mathematics>Curve>Basic */
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:area_(global_function)
*/
double	area(Curve &crv, double dYoffset = 0); // Get the area under a curve.

//Comments last updated by HF on 3/3/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:sort_(global_function)
*/
BOOL	sort(Curve &crv); // Sort a curve in ascending order of X.

//Comments last updated by Frank on 08/12/2005
// Category last updated by Echo on 06/16/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:smooth_(global_function)
*/
bool smooth(vector& vY, int imethod=0, int ileftpts = 3, int irightpts = 3, int ipolydeg = 2); // Smooth a vector using Adjacent Averaging, FFT, Median filter, or Savitzky-Golay.
///Sophy 5/7/2009 KEEP_BACKWARD_COMPATIBLE
bool smooth(Curve &crv, int imethod=0, int ileftpts = 3, int irightpts = 3, int ipolydeg = 2); // Smooth a curve using Adjacent Averaging, FFT, Median filter, or Savitzky-Golay.
///end KEEP_BACKWARD_COMPATIBLE

// Comments last updated by Iris on 07/23/2008
/**@ >Fitting*/

///Leo 30/03/05 QA70-7449 REWRITE_FITPOLY
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fitpoly_(global_function)
*/
bool fitpoly(vector& vX, vector& vY, int nOrder, vector& pCoeff = NULL, vector& pError = NULL, RegStats* psRegStats = NULL);

//Category last updated by Justin on 2007-04-05
/**@ >Mathematics>Curve>Fitting */
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fitpoly_(global_function)
*/
bool fitpoly(Curve& cv, int nOrder, vector& pCoeff = NULL, vector& pError = NULL, RegStats* psRegStats = NULL, int iBeg = 0, int iEnd = -1, double* pxmin = NULL, double *pxmax = NULL);
///END REWRITE_FITPOLY

///Leo (30/03/05) fitpoly_range is superseded by fitpoly
///Comments last updated by HF on 2/28/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fitpoly_range_(global_function)
*/
BOOL fitpoly_range(Curve &cc,int ibeg,int iend,int ipolyorder, double *coeff);  // Fit a polynomial equation to a range of a curve.

///Leo (30/03/05) this function is superseded, see REWRITE_FITPOLY
//Category last updated by Echo on 2008-06-16
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fitpoly_(global_function)
*/
BOOL fitpoly(Curve &crv, int ipolyorder, double *coeff, int inumer = 0, int idenom = 0); // Fit a polynomial equation to a curve or curve segment.


//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fitlinear_(global_function)
*/
bool fitlinear(const vector& vx, const vector& vy, vector& vCoeff, const vector& vWt=NULL, RegStats* psRegStats = NULL, bool bThroughZero = false);


/// Cloud 03/26/07 QA80-9093 v8.0589 INITIAL_PARAMETERS
//Comments last updated by Sophy on 6/16/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fit_polyline_(global_function)
*/
/// Cloud 02/21/08 PROVIDE_SEGMENT_CENTER
//bool fit_polyline(int iSize, double *px, double *py, int n, vector &slope, vector &ave=NULL, vector &cutoff=NULL);
bool fit_polyline(int iSize, double *px, double *py, int n, vector &slope, vector &ave=NULL, vector &cutoff=NULL, vector &xave=NULL);
/// End PROVIDE_SEGMENT_CENTER

/**$ >Mathematics>Curve>Baseline and Peak
	Return the position of a single peak and get the width, baseline and area optionally
*/
/// Cloud 04/03/07 ADD_PEAK_HEIGHT_CALCULATION
//double peak_pos(Curve &data, double *pWidth=NULL, double *pBaseline=NULL, double *pArea=NULL, bool bSortDataFirst=TRUE, int *pErr=NULL);
/// Fisher 2008-10-8 BUG_IN_SURFACE_FITTING_INIT_CODES
//double peak_pos(Curve &data, double *pWidth=NULL, double *pBaseline=NULL, double *pArea=NULL, double *pHeight=NULL, double *pCentroid=NULL, bool bHaveBase=TRUE, bool bSortDataFirst=TRUE, int *pErr=NULL);
//Comments last updated by Sophy on 6/16/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:peak_pos_(global_function)
*/
double peak_pos(Curve &data, double *pWidth=NULL, double *pBaseline=NULL, double *pArea=NULL, double *pHeight=NULL, double *pCentroid=NULL, bool bHaveBase=TRUE, bool bSortDataFirst=TRUE, int *pErr=NULL, int *pnDir=NULL);
/// End BUG_IN_SURFACE_FITTING_INIT_CODES
/// End ADD_PEAK_HEIGHT_CALCULATION

/**$
	Return the inflexion position with its slope of a sigmoidal curve and get left, right asymptote optionally
	Parameters:
		data = [input] The input curve.
		slope = [output]
		pLeft = [output]
		pRight = [output]
		bSortDataFirst = [input]
	Examples:
		
	Return:
*/
//int init_sigmoidal(Curve &data, vector vX, vector vY, double &bottom, double &top, double &center, double &slope);
double sig_inflex(Curve &data, double &slope, double *pLeft=NULL, double *pRight=NULL, bool bSortDataFirst=TRUE);
//Comments last updated by Sophy on 6/16/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_exponent_(global_function)
*/
/// Cloud 01/14/08 REPRESENT_SCALE_BY_EXPONENT_FOR_HUGE_NUMBER
//double get_exponent(vector &x_data, vector &y_data, double *pBase=NULL, double *pScaleExp=NULL, bool bSortDataFirst=TRUE);
double get_exponent(vector &x_data, vector &y_data, double *pBase=NULL, double *pScaleExp=NULL, int *pScaleSign=NULL, bool bSortDataFirst=TRUE);
/// End REPRESENT_SCALE_BY_EXPONENT_FOR_HUGE_NUMBER

/// Fisher qa80-14828 12/10/09 PARAM_INITIAL_VAL_TOO_BAD_FOR_SOME_DATA
void get_exponent_ex(vector &x_data, vector &y_data, double *pBase=NULL, double *pScaleExp=NULL, double *pScaleX=NULL);
/// END -------

/// Cloud 07/17/07 ADD_FFT_FOR_COMPATIBILITY
/**$ >Signal Processing>Fourier Transform
	Perform FFT on data
*/
int FFT(const vector<complex> &vc, vector<complex> &vr);
/// End ADD_FFT_FOR_COMPATIBILITY
/// End INITIAL_PARAMETERS


//Comments last updated by HF on 2/28/2005
/**$ >Analysis
		Initialize the Origin C NLSF control structure.
	Sample Data:
		2	10.54362
		4	8.85013
		6	7.51005
		8	6.23363
		10	5.31886
		12	5.04538
		14	5.47292
		16	5.6315
		18	5.09736
		20	4.94923
		22	5.10317
		24	5.02472
	Example1:

	// SAMPLE NOT REVISED (We need alternative for NLFit)

	Parameters:
		control=[input] NLSF control structure (see system header file OC_types.h for elements and initial values)   
	Return:
		Returns TRUE on success and FALSE on failure.
	SeeAlso:

*/
//BOOL	initNLSF(NLSFCntrl &control); // Initialize the Origin C NLSF control structure.

//Comments last updated by HF on 2/28/2005
/** >Analysis
		Use the Origin C NLSF control structure to fit a data set.
	Sample Data:
		2	10.54362
		4	8.85013
		6	7.51005
		8	6.23363
		10	5.31886
		12	5.04538
		14	5.47292
		16	5.6315
		18	5.09736
		20	4.94923
		22	5.10317
		24	5.02472
	Example1:

	// SAMPLE NOT REVISED (We need alternative for NLFit)

	Parameters:
		control=[input] NLSF control structure (see system header file OC_types.h for elements and initial values)   
	Return:
		Returns TRUE on success and FALSE on failure.
	SeeAlso:

*/
//BOOL	fitNLSF(NLSFCntrl &control); // Use the Origin C NLSF control structure to fit a data set.

//Comments last updated by HF on 2/28/2005
/** >Analysis
		Fit a data set having to pass only a small set of parameters.
	Sample Data:
		2	10.54362
		4	8.85013
		6	7.51005
		8	6.23363
		10	5.31886
		12	5.04538
		14	5.47292
		16	5.6315
		18	5.09736
		20	4.94923
		22	5.10317
		24	5.02472
	Example1:

	// SAMPLE NOT REVISED (We need alternative for NLFit)

	Parameters:
		strYData=[input] name of Y data set to fit
		strFitFunc=[input] name of NLSF fitting function
		iwType=[input] weighting type or method: no weighting (default 0), instrumental or weight by error bars (1),
			statistical (2), and arbitrary or weight by data set (3)  
		strWtData=[input] name of weighting data set when iwType is 3
	Return:
		Returns the Chi-Square value. 
	SeeAlso:

*/
//double	fitNLSF(string strYData, string strFitFunc, int iwType=0, string strWtData=''); // Fit a data set having to pass only a small set of parameters.

//////////////////////////////////////////////////////////////////////////////
// The following are internal Origin functions related to Datasets and Curves
//////////////////////////////////////////////////////////////////////////////

#pragma dll(@OK)	// Assoicate all functions below to Origin OK dll

// Comments last updated by Iris on 07/23/2008
/**@ >Statistics>Descriptive Statistics*/ 

//Comments last updated by HF on 2/28/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Data_sum_(global_function)
*/
BOOL	Data_sum(Dataset* pdsData, BasicStats* pbsStat, Dataset* pdsSumData=NULL); // Dataset basic summary (descriptive) statistics.

//Comments last updated by HF on 3/3/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Data_percentiles_(global_function)
*/
BOOL	Data_percentiles(Dataset* pdsData, const double ardPercents[], double ardPercentiles[], int nValues, BOOL bInterpolate=FALSE); // Calculate percentiles at given percent values for the given dataset.

//Comments last updated by HF on 3/3/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Data_sort_(global_function)
*/
BOOL	Data_sort(Dataset* pdsData, BOOL bDescending = FALSE, BOOL bMissingAsMin = FALSE); // Function to sort a data set inplace.

//Comments last updated by HF on 3/10/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Data_table_(global_function)
*/
double	Data_table(double dX, Dataset* pdsYdata, Dataset* pdsXdata = NULL); // Table lookup with interpolation.

//Comments last updated by HF on 3/10/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Data_list_(global_function)
*/
int		Data_list(double dX, Dataset* pdsData, int nPrecision = 8); // Find first occurrence of value in data set.

//Comments last updated by HF on 3/11/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Data_copy_(global_function)
*/
BOOL	Data_copy(Dataset* pdsDest, Dataset* pdsSrc, int nSrcFrom = 0, int nSrcTo=-1, int nDestFrom=-1, BOOL bIgnoreMask=TRUE); // Copy a range of data from one data set to another. 

//Comments last updated by HF on 3/10/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Curve_integrate_(global_function)
*/
BOOL	Curve_integrate(curvebase* pcrvData, IntegrationResult* pirResult, curvebase* pcrvBaseline=NULL, Dataset* pdsIntegral=NULL, BOOL bPaintShade=FALSE); // Integrate the given Curve.

//Comments last updated by HF on 3/10/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Curve_x_(global_function)
*/
double	Curve_x(curvebase* pcrvData, int nIndex); // Get X value of Curve at specified index.

//Comments last updated by HF on 2/28/2005
//Category last updated by Justin on 2007-04-05
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Curve_y_(global_function)
*/
double	Curve_y(curvebase* pcrvData, int nIndex); // Get Y value of Curve at specified index.

//Comments last updated by HF on 3/10/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Curve_xfromY_(global_function)
*/
double	Curve_xfromY(curvebase* pcrvData, double dY); // Get interpolated/extrapolated X value of Curve at specified Y value.

//Comments last updated by HF on 3/10/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Curve_yfromX_(global_function)
*/
double	Curve_yfromX(curvebase* pcrvData, double dX); // Get interpolated/extrapolated Y value of Curve at specified X value.

//Comments last updated by HF on 3/10/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Curve_bspline_(global_function)
*/
int Curve_bspline(curvebase* pcrvData, curvebase* pcrvResults, double dSmoothness = BSPLN_AUTO,  Dataset* pdsWeights = NULL); // Create a B Spline curve with optional weighting.

//Comments last updated by Frank on 3/10/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Curve_derivative_(global_function)
*/
int Curve_derivative(curvebase* pcrvData, curvebase* pcrvResults, int nOrder = 1, double dSmoothness = BSPLN_OFF, Dataset* pdsWeights = NULL ); // Create the n-th Order derivative of a source curve with optional weighting.

//Comments last updated by HF on 3/10/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Curve_MinMax_(global_function)
*/
BOOL	Curve_MinMax(const curvebase* pcuvData, double* pxMin, double* pxMax, BOOL bScanData=FALSE, double* pyMin=NULL, double* pyMax=NULL);  // Get X and Y range of the Curve

//Comments last updated by HF on 2/28/2005
//example by CPY on 5/18/2005
//Category last updated by Justin on 2007-04-04
/**@ >Fitting*/

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:nlfFit_(global_function)
*/
double	nlfFit(double dx, int nDepend = 0); // Get the value of the specified dependent variable for the specified value of the independent variable.

//Comments last updated by HF on 2/28/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:nlfXfromY_(global_function)
*/
int nlfXfromY(double dy, double* parX, int nMaxX, int nDependent=0); // Get the value(s) of the independent variable for the specified value of the specified dependent variable.

#if _OC_VER > 0x0703
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetDatasetXFromStep_(global_function)
*/
BOOL GetDatasetXFromStep(LPCSTR lpcszDatasetName, double* lpdbFrom, double* lpdbStep);


#endif // _OC_VER > 0x0703


#if _OC_VER >= 0x0800

#pragma dll(OCcontour)	// Assoicate all functions below to OCcontour.dll which must be in the Origin EXE folder

//Comments last updated by HF on 3/2/2005
/**$
*/
int find_contours(float* gVal, int ngVals, float* lpData, int nRows, int nCols, TreeNode* pTreeNode, int nMinSize = 30, float fMinRoundness = 0.5, float fMinArea = 0, DWORD dwOptions = 0);

//Comments last updated by HF on 3/2/2005
/**$
*/
float find_level_with_most_objects(float fMin, float fMax, float* lpData, int nRows, int nCols, int nMinSize, int nLevels);

#pragma dll()

///------ Folger 11/30/09 CENTRALIZE_CODE_ABOUT_FIND_ROOTS
// /// Fisher 4/1/2009 QA80-13388 ROOT_FINDING_FUNCTION
// //Comments last updated by Sophy on 6/16/2009
// /**+
//_http://ocwiki.originlab.com/index.php?title=OriginC:find_roots_(global_function)
// */
// /// Iris 11/10/2009 QA80-13388 ZERO_CROSSING_DIRECTION
// //int		find_roots(const vector &vx, const vector &vy, vector &roots, double dBase = 0.0);
// int		find_roots(const vector &vx, const vector &vy, vector &roots, double dBase = 0.0, vector<int> &vnDirection = NULL);
// ///end ZERO_CROSSING_DIRECTION
// /// End ROOT_FINDING_FUNCTION
///------ End CENTRALIZE_CODE_ABOUT_FIND_ROOTS

//#include "ocMath.h"

///------ Folger 03/31/10 QA81-15258 XF_GETPTS_NEEDED
int GetPoints(string strPage, int& nPoints, int nReaderType, vector<string>& vsPlots, vector& vx, vector& vy, vector& vIndices);
///------ End QA81-15258 XF_GETPTS_NEEDED

#endif //#if _OC_VER >= 0x0800


#endif //_DATA_H
